<?php
/*
Plugin Name: 123Dentist Clinic Owner Info Plugin
Plugin URI: http://aheadoftheweb.com/
Description: This plugin display's Owners' names on clinic site.
Author: Ahead of the Web
Author URI: http://aheadoftheweb.com
Version: 2.0
*/

/**
 * Setup native automatic theme update functionality
 */
require 'update-checker/plugin-update-checker.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	'https://updates.aheadoftheweb.com/?action=get_metadata&slug=aow_owners',
	__FILE__,
	'aow_owners'
);


// Uninstall script
register_uninstall_hook(__FILE__,'aow_owners_child_deactivate');
// On uninstall delete all database entires made by the plugin
function aow_owners_child_deactivate(){
	delete_option( 'widget_sc123_child_owners' );
	delete_option( 'sc123_owners_hastitle' );
	delete_option( 'sc123_owners_title' );
	delete_option( 'sc123_owners_content' );
	delete_option( 'sc123_owners_displaystate' );
}
add_action( 'admin_menu', 'aow_owners_menu_items' );
function aow_owners_menu_items(){
	
	// Create main menu instance in child dashboard
	add_menu_page( 'Clinic Owners', 'Clinic Owners', 'manage_options', 'aow-owners', 'aow_owners_home' );
	add_submenu_page('aow-owners' , 'Owners Info' , 'Owner Info' , 'manage_options' , 'aow-owners-home' , 'aow_owners_content');
	
}


// Include file for Home View 
function aow_owners_home(){
	require_once('includes/view-home.php');
}

// Include file for Owners Content Management
function aow_owners_content(){
	require_once('includes/view-owners-content.php');
}


// Load custom CSS for styling widgets
/*add_action( 'wp_enqueue_scripts', 'aow_owners_register_plugin_styles' );

function aow_owners_register_plugin_styles() {
    wp_register_style( 'aow-owners', plugins_url( 'aow_owners/css/contentshare.css' ) );
	$siteurl = get_option('siteurl');
    $url = $siteurl . '/wp-content/plugins/' . basename(dirname(__FILE__)) . '/css/contentshare.css';
    echo "<link rel='stylesheet' type='text/css' href='$url' />\n";
}*/


// Register shortcode versions of widgets
add_shortcode('showowners','aowowners_func');

// Shortcode Function
// Shortcode for owners content
function aowowners_func($atts){
	ob_start();
	$owner_content = get_option("aow_123_owners");
	$defaulttitle='Our Owners Are'; 
	echo '<div class="owners_shortcode">';
		echo '<p>';
		echo esc_html( __( $owner_content, 'text_domain' ) );
		echo '</p>';
		echo '</div>';
	return ob_get_clean();
}

if ( isset( $_POST[ 'owners-text' ] ) && $_POST[ 'owners-text' ] != '') {
	$owner_text = sanitize_text_field( $_POST[ 'owners-text' ] );
	update_option( 'aow_123_owners', $owner_text );
}

?>