<?php



/**

 * The plugin bootstrap file

 *

 * This file is read by WordPress to generate the plugin information in the plugin

 * admin area. This file also includes all of the dependencies used by the plugin,

 * registers the activation and deactivation functions, and defines a function

 * that starts the plugin.

 *

 * @link              https://123dentist.com/

 * @since             1.0.0

 * @package           Aow_gf_failure_notification

 *

 * @wordpress-plugin

 * Plugin Name:       AOW - Gravity Forms Failure Notification

 * Plugin URI:        https://123dentist.com/

 * Description:       Creates a ticket task if Gravity Forms fails to submit a notification.

 * Version:           1.1.2

 * Author:            Graeme

 * Author URI:        https://123dentist.com/

 * License:           GPL-2.0+

 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt

 * Text Domain:       aow_gf_failure_notification

 * Domain Path:       /languages

 */

/**

 * Setup native automatic theme update functionality

 */

require 'update-checker/plugin-update-checker.php';

$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(

  'https://updates.aheadoftheweb.com/?action=get_metadata&slug=aow_gf_failure_notification',

  __FILE__,

  'aow_gf_failure_notification'

);



// If this file is called directly, abort.

if ( ! defined( 'WPINC' ) ) {

	die;

}



/**

 * Currently plugin version.

 * Start at version 1.0.0 and use SemVer - https://semver.org

 * Rename this for your plugin and update it as you release new versions.

 */

define( 'AOW_GF_FAILURE_NOTIFICATION_VERSION', '1.1.0' );



/**

 * The code that runs during plugin activation.

 * This action is documented in includes/class-aow_gf_failure_notification-activator.php

 */

function activate_aow_gf_failure_notification() {

	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aow_gf_failure_notification-activator.php';

	Aow_gf_failure_notification_Activator::activate();

}



/**

 * The code that runs during plugin deactivation.

 * This action is documented in includes/class-aow_gf_failure_notification-deactivator.php

 */

function deactivate_aow_gf_failure_notification() {

	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aow_gf_failure_notification-deactivator.php';

	Aow_gf_failure_notification_Deactivator::deactivate();

}



register_activation_hook( __FILE__, 'activate_aow_gf_failure_notification' );

register_deactivation_hook( __FILE__, 'deactivate_aow_gf_failure_notification' );



/**

 * The core plugin class that is used to define internationalization,

 * admin-specific hooks, and public-facing site hooks.

 */

require plugin_dir_path( __FILE__ ) . 'includes/class-aow_gf_failure_notification.php';



/**

 * Begins execution of the plugin.

 *

 * Since everything within the plugin is registered via hooks,

 * then kicking off the plugin from this point in the file does

 * not affect the page life cycle.

 *

 * @since    1.0.0

 */

function run_aow_gf_failure_notification() {



	$plugin = new Aow_gf_failure_notification();

	$plugin->run();



}

run_aow_gf_failure_notification();

